/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vpdmgr;

import com.ibm.hwmca.base.vpdmgr.VpdData;
import com.ibm.hwmca.base.vpdmgr.VpdManagerException;
import com.ibm.hwmca.base.vpdmgr.VpdManagerInvalidCcinException;
import com.ibm.hwmca.base.vpdmgr.VpdManagerInvalidCommandException;
import com.ibm.hwmca.base.vpdmgr.VpdManagerInvalidLocationException;
import com.ibm.hwmca.base.vpdmgr.VpdManagerInvalidPartNumberException;
import com.ibm.hwmca.base.vpdmgr.VpdManagerMoveLengthErrorException;
import com.ibm.hwmca.base.vpdmgr.VpdManagerNoNewDataException;
import com.ibm.hwmca.base.vpdmgr.VpdManagerNoNewLocationException;
import com.ibm.hwmca.base.vpdmgr.VpdManagerNoUnitDataException;
import com.ibm.hwmca.base.vpdmgr.VpdManagerNotFoundException;
import com.ibm.hwmca.base.vpdmgr.VpdManagerSameDataException;
import com.ibm.hwmca.fw.bridge.NativeBridge;
import com.ibm.hwmca.fw.bridge.NativeBridgeException;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;

public class VpdManager {
    private static final String TRACE_MASKT = "XVPDMGRT";
    private static final String TRACE_MASKF = "XVPDMGRF";
    private static final String TRACE_MASKD = "XVPDMGRD";
    private static VpdManager vpdmgr;
    private NativeBridge bridge;

    private VpdManager() {
        Trace.trace(TRACE_MASKT, "<> VpdManager ");
    }

    public static synchronized VpdManager getVpdManager() {
        Trace.trace(TRACE_MASKT, "<> getVpdManager ");
        if (vpdmgr == null) {
            vpdmgr = new VpdManager();
        }
        return vpdmgr;
    }

    public VpdData callVpdManager(VpdData vpdInputData) throws VpdManagerException {
        Trace.trace(TRACE_MASKD, "callVpdManager start()");
        int intrc = 0;
        try {
            if (this.bridge == null) {
                this.bridge = new NativeBridge();
                NativeProcessParameters nativeProcessParameters = new NativeProcessParameters("actzNativeBridgeMain");
                this.bridge.exec(nativeProcessParameters);
            }
            Object[] args = new Object[]{vpdInputData};
            Trace.trace(TRACE_MASKF, "invokeNativeFunction");
            Object result = this.bridge.invokeNativeFunction("iqyvpd", "java_xvpd_mgr", args);
            intrc = ((VpdData)result).getIntRc();
            return (VpdData)result;
        }
        catch (IOException ioe) {
            String errorMsg = "An error occured during NativeBridge processing";
            throw new VpdManagerException(ioe);
        }
        catch (NativeBridgeException nbe) {
            VpdManager.handleNativeBridgeException(nbe);
            return null;
        }
    }

    private static void handleNativeBridgeException(NativeBridgeException nbe) throws VpdManagerException {
        String errorMsg = "Internal VpdManager error";
        Trace.trace(TRACE_MASKF, "Native bridge error code = " + nbe.getErrorCode());
        if (nbe.areReturnCodesSet()) {
            int src = nbe.getSystemReturnCode();
            int crc = nbe.getComponentReturnCode();
            Trace.trace(TRACE_MASKF, "System return code = " + src + "; component return code = " + crc);
            if (src == 2) {
                switch (crc) {
                    case 19: {
                        throw new VpdManagerInvalidCcinException(nbe);
                    }
                    case 16: {
                        throw new VpdManagerInvalidCommandException(nbe);
                    }
                    case 17: {
                        throw new VpdManagerInvalidLocationException(nbe);
                    }
                    case 18: {
                        throw new VpdManagerInvalidPartNumberException(nbe);
                    }
                    case 22: {
                        throw new VpdManagerMoveLengthErrorException(nbe);
                    }
                    case 32: {
                        throw new VpdManagerNoNewDataException(nbe);
                    }
                    case 21: {
                        throw new VpdManagerNoNewLocationException(nbe);
                    }
                    case 23: {
                        throw new VpdManagerNoUnitDataException(nbe);
                    }
                    case 1: {
                        throw new VpdManagerNotFoundException(nbe);
                    }
                    case 20: {
                        throw new VpdManagerSameDataException(nbe);
                    }
                }
                errorMsg = "Error occurred during VPD Manager call";
            } else {
                switch (src) {
                    case 1: {
                        errorMsg = "No Component Return Code available from VPD Manager.";
                        break;
                    }
                    default: {
                        errorMsg = "Internal VpdManager error";
                    }
                }
            }
        } else {
            errorMsg = "Error in VpdManager during NativeBridge processing occured";
        }
        Trace.trace(TRACE_MASKF, "Throw VpdManagerException: " + errorMsg);
        throw new VpdManagerException(errorMsg);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    protected synchronized void close() throws IOException {
        if (this.bridge != null) {
            this.bridge.sendRequestToExit();
            this.bridge.close();
            this.bridge = null;
        }
    }
}

